'use strict';
(function () {
  let cardColor, labelColor, shadeColor, legendColor, borderColor;

  if (isDarkStyle) {
    cardColor = config.colors_dark.cardColor;
    labelColor = config.colors_dark.textMuted;
    legendColor = config.colors_dark.bodyColor;
    borderColor = config.colors_dark.borderColor;
    shadeColor = 'dark';
  } else {
    cardColor = config.colors.cardColor;
    labelColor = config.colors.textMuted;
    legendColor = config.colors.bodyColor;
    borderColor = config.colors.borderColor;
    shadeColor = '';
  }

  // Function to configure and return bar chart options
  function EarningReportsBarChart(arrayData, highlightData, isCurrency = false) {
    const basicColor = config.colors_label.primary;
    const highlightColor = config.colors.primary;
    const colorArr = arrayData.map((_, index) =>
      index === highlightData ? highlightColor : basicColor
    );

    return {
      chart: {
        height: 258,
        parentHeightOffset: 0,
        type: 'bar',
        toolbar: {
          show: false
        }
      },
      plotOptions: {
        bar: {
          columnWidth: '32%',
          startingShape: 'rounded',
          borderRadius: 7,
          distributed: true,
          dataLabels: {
            position: 'top'
          }
        }
      },
      grid: {
        show: false,
        padding: {
          top: 0,
          bottom: 0,
          left: -10,
          right: -10
        }
      },
      colors: colorArr,
      dataLabels: {
        enabled: true,
        formatter: function (val) {
          return isCurrency ? `R$${val.toFixed(2).replace('.', ',')}` : val;
        },
        offsetY: -20,
        style: {
          fontSize: '15px',
          colors: [legendColor],
          fontWeight: '500',
          fontFamily: 'Public Sans'
        }
      },
      series: [
        {
          data: arrayData
        }
      ],
      legend: {
        show: false
      },
      tooltip: {
        enabled: false
      },
      xaxis: {
        categories: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'],
        axisBorder: {
          show: true,
          color: borderColor
        },
        axisTicks: {
          show: false
        },
        labels: {
          style: {
            colors: labelColor,
            fontSize: '13px',
            fontFamily: 'Public Sans'
          }
        }
      },
      yaxis: {
        labels: {
          offsetX: -15,
          formatter: function (val) {
            return isCurrency ? `R$${val.toFixed(2).replace('.', ',')}` : val;
          },
          style: {
            fontSize: '13px',
            colors: labelColor,
            fontFamily: 'Public Sans'
          },
          min: 0,
          max: 60000,
          tickAmount: 6
        }
      },
      responsive: [
        {
          breakpoint: 1441,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '41%'
              }
            }
          }
        },
        {
          breakpoint: 590,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '61%',
                borderRadius: 5
              }
            },
            yaxis: {
              labels: {
                show: false
              }
            },
            grid: {
              padding: {
                right: 0,
                left: -20
              }
            },
            dataLabels: {
              style: {
                fontSize: '12px',
                fontWeight: '400'
              }
            }
          }
        }
      ]
    };
  }

  // Function to fetch data and render charts
  function fetchDataAndRenderCharts() {
    const userIdInput = document.getElementById('userId');
    let userId = userIdInput ? userIdInput.value : null;

    if (!userId) {
      console.error('userId não está definido.');
      return;
    }

    const earningReportsUrl = `/api/earning-reports?user_id=${userId}`;

    fetch(earningReportsUrl)
      .then(response => response.json())
      .then(data => {
        if (!data || !data.data) {
          throw new Error('Dados do gráfico não encontrados');
        }

        const earningReportsChart = data;

        // Earning Reports Tabs Orders
        const earningReportsTabsOrdersEl = document.querySelector('#earningReportsTabsOrders');
        if (earningReportsTabsOrdersEl && earningReportsChart.data[0]) {
          const earningReportsTabsOrdersConfig = EarningReportsBarChart(
            [earningReportsChart.data[0].chart_data],
            earningReportsChart.data[0].active_option,
            false // Não é valor monetário
          );
          const earningReportsTabsOrders = new ApexCharts(earningReportsTabsOrdersEl, earningReportsTabsOrdersConfig);
          earningReportsTabsOrders.render();
        }

        // Earning Reports Tabs Sales
        const earningReportsTabsSalesEl = document.querySelector('#earningReportsTabsSales');
        if (earningReportsTabsSalesEl && earningReportsChart.data[1]) {
          const earningReportsTabsSalesConfig = EarningReportsBarChart(
            [earningReportsChart.data[1].chart_data],
            earningReportsChart.data[1].active_option,
            true // É valor monetário
          );
          const earningReportsTabsSales = new ApexCharts(earningReportsTabsSalesEl, earningReportsTabsSalesConfig);
          earningReportsTabsSales.render();
        }

        // Earnings Last 7 Days
        const earningsLast7DaysEl = document.querySelector('#earningsLast7Days');
        if (earningsLast7DaysEl && earningReportsChart.data[3]) {
          const earningsLast7DaysConfig = {
            chart: {
              height: 200,
              type: 'line',
              parentHeightOffset: 0,
              toolbar: {
                show: false
              }
            },
            series: [
              {
                name: 'Ganhos',
                data: Object.values(earningReportsChart.data[3].chart_data)
              }
            ],
            xaxis: {
              categories: Object.keys(earningReportsChart.data[3].chart_data),
              labels: {
                style: {
                  colors: labelColor,
                  fontSize: '13px',
                  fontFamily: 'Public Sans'
                }
              }
            },
            yaxis: {
              labels: {
                style: {
                  colors: labelColor,
                  fontSize: '13px',
                  fontFamily: 'Public Sans'
                },
                formatter: function (val) {
                  return `R$${val.toFixed(2).replace('.', ',')}`;
                }
              }
            },
            colors: [config.colors.primary],
            grid: {
              borderColor: borderColor
            },
            stroke: {
              width: 2,
              curve: 'smooth'
            },
            markers: {
              size: 5,
              colors: [config.colors.primary],
              strokeColors: borderColor,
              strokeWidth: 2
            },
            tooltip: {
              theme: 'dark'
            }
          };
          const earningsLast7Days = new ApexCharts(earningsLast7DaysEl, earningsLast7DaysConfig);
          earningsLast7Days.render();
        }
      })
      .catch(error => console.error('Erro ao buscar dados dos gráficos:', error));
  }

  document.addEventListener('DOMContentLoaded', fetchDataAndRenderCharts);
})();
